/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class AnchorModifier
extends Modifier
implements GeneralInteractionModifierHook {
    public static final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "anchor_charge");
    private static final ResourceLocation DIM = new ResourceLocation("tinkerscalibration", "dim");

    public AnchorModifier() {
        MinecraftForge.EVENT_BUS.addListener(AnchorModifier::onReborn);
    }

    private static void onReborn(PlayerEvent.PlayerRespawnEvent event) {
        Level world = event.getPlayer().m_20193_();
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ToolStack tool;
            ItemStack stack;
            if (slot == EquipmentSlot.MAINHAND || (stack = player.m_6844_(slot)).m_41619_() || !(tool = ToolStack.from((ItemStack)stack)).getPersistentData().contains(KEY, 5) || !tool.getPersistentData().contains(DIM, 5) || player.m_8963_().m_135782_() != DIM) continue;
            BlockPos pos = new BlockPos(world.m_6106_().m_6789_(), world.m_6106_().m_6527_(), world.m_6106_().m_6526_());
            player.m_9158_(Level.f_46428_, pos, 0.0f, false, true);
            tool.getPersistentData().remove(DIM);
        }
    }

    public List<ItemStack> processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        ModDataNBT persistantData = tool.getPersistentData();
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            ServerLevel world = context.m_78952_();
            if (!stack.m_150930_(Blocks.f_50141_.m_5456_()) || !(persistantData.getFloat(KEY) <= (float)(4 * level))) continue;
            iterator.remove();
            persistantData.putFloat(KEY, persistantData.getFloat(KEY) + 1.0f);
        }
        return generatedLoot;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CHARGEABLE_INTERACT);
    }

    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken() && persistentData.contains(KEY, 5)) {
            ModifierUtil.startUsingItem((IToolStackView)tool, (ModifierId)modifier.getId(), (LivingEntity)player, (InteractionHand)hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        ModDataNBT persistentData = tool.getPersistentData();
        Level world = entity.m_20193_();
        if (!world.f_46443_) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_9158_(world.m_46472_(), player.m_20097_(), 0.0f, false, true);
            persistentData.putFloat(KEY, persistentData.getFloat(KEY) - 1.0f);
            persistentData.putString(DIM, String.valueOf(world.m_46472_()));
            world.m_6263_(null, player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }
}

